/*
 * Decompiled with CFR 0.152.
 */
package jace.ui;

import jace.core.Computer;
import jace.ui.AbstractEmulatorFrame;
import jace.ui.DebuggerPanel;
import jace.ui.OutlinedLabel;
import jace.ui.ScreenPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

public class EmulatorFrame
extends AbstractEmulatorFrame {
    public static final long serialVersionUID = -1100L;
    Font labelFont;
    public DebuggerPanel debuggerPanel;
    public JLayeredPane layers;
    public ScreenPanel screen;
    Set<JLabel> previousIndicators = new HashSet<JLabel>();
    Map<ImageIcon, JLabel> indicatorCache = new HashMap<ImageIcon, JLabel>();

    @Override
    public String getShortName() {
        return "frame";
    }

    @Override
    public DebuggerPanel getDebuggerPanel() {
        return this.debuggerPanel;
    }

    @Override
    public Component getScreen() {
        return this.screen;
    }

    @Override
    public void resizeVideo() {
        super.resizeVideo();
        this.layers.setLayer(this.screen, this.layers.lowestLayer());
        this.layers.validate();
    }

    public EmulatorFrame() {
        this.initComponents();
        this.layers.setDoubleBuffered(true);
        this.screen.setDoubleBuffered(true);
        this.labelFont = Font.decode("Ubuntu-BOLD-14");
        if (this.labelFont == null) {
            this.labelFont = Font.decode("Arial-BOLD-14");
        }
        this.layers.setBounds(this.getContentPane().getBounds());
        this.screen.setBounds(this.layers.getBounds());
        this.debuggerPanel.setVisible(false);
        this.layers.setPosition(this.screen, 10);
        this.layers.setPosition(this.debuggerPanel, 2);
        this.reconfigure();
        this.screen.setFocusTraversalKeysEnabled(false);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.layers.addKeyListener(l);
        this.screen.addKeyListener(l);
    }

    private void initComponents() {
        this.layers = new JLayeredPane();
        this.screen = new ScreenPanel();
        this.debuggerPanel = new DebuggerPanel();
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(0, 0, 0));
        this.setCursor(new Cursor(0));
        this.layers.setBackground(new Color(0, 0, 64));
        this.layers.setOpaque(true);
        GroupLayout screenLayout = new GroupLayout(this.screen);
        this.screen.setLayout(screenLayout);
        screenLayout.setHorizontalGroup(screenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 560, Short.MAX_VALUE));
        screenLayout.setVerticalGroup(screenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 520, Short.MAX_VALUE));
        this.screen.setBounds(0, 0, 560, 520);
        this.layers.add((Component)this.screen, JLayeredPane.DEFAULT_LAYER);
        this.debuggerPanel.setBounds(460, 0, 100, 492);
        this.layers.add((Component)this.debuggerPanel, JLayeredPane.MODAL_LAYER);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.layers, -1, 560, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.layers, -1, 518, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new EmulatorFrame().setVisible(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRedrawIndicators(Set<ImageIcon> ind) {
        Set<JLabel> set = this.previousIndicators;
        synchronized (set) {
            for (JLabel l : this.previousIndicators) {
                l.setVisible(false);
                this.layers.remove(l);
            }
            this.previousIndicators.clear();
        }
        if (ind != null && !ind.isEmpty()) {
            int x = this.layers.getWidth();
            int y = this.layers.getHeight();
            for (ImageIcon i : this.visibleIndicators) {
                JLabel label = this.createIndicatorIcon(i);
                this.layers.add(label);
                this.layers.setLayer(label, this.layers.highestLayer());
                label.setBounds(x -= i.getIconWidth() + 10, y - i.getIconHeight() - 10, i.getIconWidth() + 5, i.getIconHeight() + 5);
                if (x <= 80) {
                    x = this.layers.getWidth();
                    y -= 140;
                }
                Set<JLabel> set2 = this.previousIndicators;
                synchronized (set2) {
                    this.previousIndicators.add(label);
                }
                label.setVisible(true);
            }
        } else if (Computer.getComputer() != null && Computer.getComputer().video != null) {
            Computer.getComputer().video.forceRefresh();
        }
        this.screen.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaintIndicators() {
        Set<JLabel> set = this.previousIndicators;
        synchronized (set) {
            if (this.previousIndicators != null) {
                for (JLabel l : this.previousIndicators) {
                    Graphics g = l.getGraphics();
                    if (g == null) continue;
                    l.paint(g);
                }
            }
        }
    }

    private JLabel createIndicatorIcon(ImageIcon i) {
        if (this.indicatorCache.containsKey(i)) {
            return this.indicatorCache.get(i);
        }
        OutlinedLabel label = new OutlinedLabel(i.getDescription());
        label.setIcon(i);
        label.setHorizontalTextPosition(0);
        label.setVerticalTextPosition(0);
        label.setBackground(Color.BLACK);
        label.setForeground(Color.WHITE);
        label.setFont(this.labelFont);
        label.setOpaque(false);
        label.setFocusable(false);
        label.setBounds(0, 0, i.getIconWidth(), i.getIconHeight());
        BufferedImage img = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 2);
        ((JComponent)label).paint(img.getGraphics());
        ImageIcon icon = new ImageIcon(img);
        JLabel renderedLabel = new JLabel(icon);
        this.indicatorCache.put(i, renderedLabel);
        return renderedLabel;
    }
}

